/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.kongchen.swagger.docgen.mustache.MustacheApi;
import com.github.kongchen.swagger.docgen.mustache.MustacheItem;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameter;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameterSet;
import com.github.kongchen.swagger.docgen.mustache.MustacheResponseClass;
import com.github.kongchen.swagger.docgen.util.Utils;
import com.wordnik.swagger.core.ApiValues;
import com.wordnik.swagger.core.util.ModelUtil;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.Model;
import com.wordnik.swagger.model.ModelProperty;
import com.wordnik.swagger.model.ModelRef;
import com.wordnik.swagger.model.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.mutable.LinkedEntry;

public class MustacheDocument
implements Comparable<MustacheDocument> {
    protected static final String VOID = "void";
    protected static final String ARRAY = "Array";
    private static final String LIST = "List";
    @JsonIgnore
    private final java.util.Map<String, Model> models = new HashMap<String, Model>();
    private final int index;
    private String resourcePath;
    private String description;
    private List<MustacheApi> apis = new ArrayList<MustacheApi>();
    @JsonIgnore
    private Set<String> requestTypes = new LinkedHashSet<String>();
    @JsonIgnore
    private Set<String> responseTypes = new LinkedHashSet<String>();
    @JsonIgnore
    private int apiIndex = 1;

    public MustacheDocument(ApiListing apiListing) {
        if (!apiListing.models().isEmpty()) {
            this.models.putAll(JavaConversions.mapAsJavaMap((Map)((Map)apiListing.models().get())));
        }
        this.resourcePath = apiListing.resourcePath();
        this.index = apiListing.position();
        this.apis = new ArrayList<MustacheApi>(apiListing.apis().size());
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getDescription() {
        return this.description;
    }

    public List<MustacheApi> getApis() {
        return this.apis;
    }

    public Set<String> getRequestTypes() {
        return this.requestTypes;
    }

    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public int getIndex() {
        return this.index;
    }

    public void addApi(MustacheApi wapi) {
        this.apis.add(wapi);
    }

    public void addResponseType(MustacheResponseClass clz) {
        if (clz.getClassName() == null) {
            return;
        }
        String newName = this.addModels(JavaConversions.mapAsJavaMap((Map)ModelUtil.modelAndDependencies((String)clz.getClassName())));
        if (newName == null) {
            this.responseTypes.add(clz.getClassLinkName());
            return;
        }
        if (newName.equals(clz.getClassLinkName())) {
            this.responseTypes.add(newName);
        }
    }

    public List<MustacheParameterSet> analyzeParameters(List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        LinkedList<MustacheParameterSet> list = new LinkedList<MustacheParameterSet>();
        java.util.Map<String, List<MustacheParameter>> paraMap = this.toParameterTypeMap(parameters);
        for (Map.Entry<String, List<MustacheParameter>> entry : paraMap.entrySet()) {
            list.add(new MustacheParameterSet(entry));
        }
        return list;
    }

    private java.util.Map<String, List<MustacheParameter>> toParameterTypeMap(List<Parameter> parameters) {
        HashMap<String, List<MustacheParameter>> paraMap = new HashMap<String, List<MustacheParameter>>();
        for (Parameter para : parameters) {
            MustacheParameter mustacheParameter = this.analyzeParameter(para);
            LinkedList<MustacheParameter> paraList = (LinkedList<MustacheParameter>)paraMap.get(para.paramType());
            if (paraList == null) {
                paraList = new LinkedList<MustacheParameter>();
                paraMap.put(para.paramType(), paraList);
            }
            paraList.add(mustacheParameter);
        }
        return paraMap;
    }

    private MustacheParameter analyzeParameter(Parameter para) {
        MustacheParameter mustacheParameter = null;
        mustacheParameter = new MustacheParameter(para);
        if (this.models.get(mustacheParameter.getLinkType()) == null) {
            mustacheParameter.setName(para.name());
        } else {
            if (mustacheParameter.getLinkType() != null && !para.paramType().equals(ApiValues.TYPE_HEADER())) {
                this.requestTypes.add(mustacheParameter.getLinkType());
            }
            if (para.name() != null) {
                mustacheParameter.setName(para.name());
            } else {
                mustacheParameter.setName(para.dataType());
            }
        }
        return mustacheParameter;
    }

    public List<MustacheItem> analyzeDataTypes(String responseClass) {
        ArrayList<MustacheItem> mustacheItemList = new ArrayList<MustacheItem>();
        if (responseClass == null || responseClass.equals(VOID)) {
            return mustacheItemList;
        }
        Model field = this.models.get(responseClass);
        if (field != null && field.properties() != null) {
            Iterator it = field.properties().entriesIterator();
            while (it.hasNext()) {
                ModelRef item;
                LinkedEntry entry = (LinkedEntry)it.next();
                MustacheItem mustacheItem = new MustacheItem((String)entry.key(), (ModelProperty)entry.value());
                Option itemOption = ((ModelProperty)entry.value()).items();
                ModelRef modelRef = item = itemOption.isEmpty() ? null : (ModelRef)itemOption.get();
                if (mustacheItem.getType().equalsIgnoreCase(ARRAY) || mustacheItem.getType().equalsIgnoreCase(LIST)) {
                    this.handleArrayType(mustacheItem, item);
                } else if (this.models.get(mustacheItem.getType()) != null) {
                    this.responseTypes.add(mustacheItem.getType());
                }
                mustacheItemList.add(mustacheItem);
            }
        }
        return mustacheItemList;
    }

    private void handleArrayType(MustacheItem mustacheItem, ModelRef item) {
        if (item != null) {
            if (item.type() == null && item.ref() != null) {
                mustacheItem.setTypeAsArray(Utils.getStrInOption((Option<String>)item.ref()));
                this.responseTypes.add(Utils.getStrInOption((Option<String>)item.ref()));
            } else {
                mustacheItem.setTypeAsArray(item.type());
            }
        }
    }

    @Override
    public int compareTo(MustacheDocument o) {
        if (o == null) {
            return 1;
        }
        return this.getResourcePath().compareTo(o.getResourcePath());
    }

    public String addModels(java.util.Map<String, Model> modelMap) {
        if (modelMap == null || modelMap.isEmpty()) {
            return null;
        }
        for (String key : modelMap.keySet()) {
            this.models.put(key, modelMap.get(key));
        }
        return modelMap.keySet().iterator().next();
    }
}

