/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.jaxrs.reader.DefaultJaxrsApiReader;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ApiListingReference;
import com.wordnik.swagger.model.ResourceListing;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import scala.None;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;

public class MavenDocumentSource
extends AbstractDocumentSource {
    private final ApiSource apiSource;

    public MavenDocumentSource(ApiSource apiSource, Log log) {
        super(new LogAdapter(log), apiSource.getOutputPath(), apiSource.getOutputTemplate(), apiSource.getSwaggerDirectory(), apiSource.mustacheFileRoot, apiSource.isUseOutputFlatStructure());
        this.setApiVersion(apiSource.getApiVersion());
        this.setBasePath(apiSource.getBasePath());
        this.apiSource = apiSource;
    }

    @Override
    public void loadDocuments() throws GenerateException {
        SwaggerConfig swaggerConfig = new SwaggerConfig();
        swaggerConfig.setApiVersion(this.apiSource.getApiVersion());
        swaggerConfig.setSwaggerVersion(SwaggerSpec.version());
        ArrayList<ApiListingReference> apiListingReferences = new ArrayList<ApiListingReference>();
        ArrayList authorizationTypes = new ArrayList();
        for (Class c : this.apiSource.getValidClasses()) {
            ApiListing doc;
            try {
                doc = this.getDocFromClass(c, swaggerConfig, this.getBasePath());
            }
            catch (Exception e) {
                throw new GenerateException(e);
            }
            if (doc == null) continue;
            this.LOG.info("Detect Resource:" + c.getName());
            Buffer buffer = doc.authorizations().toBuffer();
            authorizationTypes.addAll(JavaConversions.asJavaList((Buffer)buffer));
            ApiListingReference apiListingReference = new ApiListingReference(doc.resourcePath(), doc.description(), doc.position());
            apiListingReferences.add(apiListingReference);
            this.acceptDocument(doc);
        }
        this.serviceDocument = new ResourceListing(swaggerConfig.apiVersion(), swaggerConfig.swaggerVersion(), List.fromIterator((Iterator)JavaConversions.asScalaIterator(apiListingReferences.iterator())), List.fromIterator((Iterator)JavaConversions.asScalaIterator(authorizationTypes.iterator())), swaggerConfig.info());
    }

    private ApiListing getDocFromClass(Class c, SwaggerConfig swaggerConfig, String basePath) throws Exception {
        Api resource = c.getAnnotation(Api.class);
        if (resource == null) {
            return null;
        }
        DefaultJaxrsApiReader reader = new DefaultJaxrsApiReader();
        Option apiListing = reader.read(basePath, c, swaggerConfig);
        if (None.canEqual((Object)apiListing)) {
            return null;
        }
        return (ApiListing)apiListing.get();
    }
}

