/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.MavenDocumentSource;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ApiDocumentMojo
extends AbstractMojo {
    private List<ApiSource> apiSources;

    public List<ApiSource> getApiSources() {
        return this.apiSources;
    }

    public void setApiSources(List<ApiSource> apiSources) {
        this.apiSources = apiSources;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.apiSources == null) {
            throw new MojoFailureException("You must configure at least one apiSources element");
        }
        try {
            Class<?> tryClass = Class.forName("com.wordnik.swagger.annotations.ApiErrors");
            throw new MojoExecutionException("You may use an old version of swagger which is not supported by swagger-maven-plugin 2.0+\nswagger-maven-plugin 2.0+ only supports swagger-core 1.3.x");
        }
        catch (ClassNotFoundException e) {
            try {
                this.getLog().debug((CharSequence)this.apiSources.toString());
                for (ApiSource apiSource : this.apiSources) {
                    File outputDirectory = new File(apiSource.getOutputPath()).getParentFile();
                    if (outputDirectory != null && !outputDirectory.exists() && !outputDirectory.mkdirs()) {
                        throw new MojoExecutionException("Create directory[" + apiSource.getOutputPath() + "] for output failed.");
                    }
                    MavenDocumentSource documentSource = new MavenDocumentSource(apiSource, this.getLog());
                    ((AbstractDocumentSource)documentSource).loadDocuments();
                    documentSource.toDocuments();
                    documentSource.toSwaggerDocuments();
                }
            }
            catch (GenerateException e2) {
                throw new MojoFailureException(e2.getMessage(), (Throwable)e2);
            }
            catch (Exception e3) {
                throw new MojoExecutionException(e3.getMessage(), e3);
            }
            return;
        }
    }
}

