/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    private static final List<String> basicTypes;
    private static final Pattern pattern;
    public static final Pattern genericPattern;

    public static String getTrueType(String dataType) {
        String t;
        if (dataType == null) {
            return null;
        }
        Matcher m = pattern.matcher(dataType);
        if (m.find()) {
            t = m.group(2);
        } else {
            m = genericPattern.matcher(dataType);
            if (m.find()) {
                try {
                    t = m.group(1);
                }
                catch (IllegalStateException e) {
                    System.out.println(dataType);
                    return dataType;
                }
            } else {
                t = dataType;
            }
        }
        if (basicTypes.contains(t)) {
            t = null;
        }
        return t;
    }

    public static String filterBasicTypes(String linkType) {
        if (basicTypes.contains(linkType)) {
            return null;
        }
        return linkType;
    }

    public static String upperCaseFirstCharacter(String inputString) {
        return inputString.substring(0, 1).toUpperCase() + inputString.substring(1);
    }

    public static String AsArrayType(String elementType) {
        return "Array[" + elementType + "]";
    }

    static {
        String[] a = new String[]{"string", "boolean", "Date", "int", "Array", "long", "List", "void", "float", "double"};
        basicTypes = Arrays.asList(a);
        pattern = Pattern.compile("^(Array|List)\\[(\\w+)]$");
        genericPattern = Pattern.compile("^(.*)<.*>$");
    }
}

