/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mustache.OutputTemplate;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.wordnik.swagger.core.util.JsonSerializer;
import com.wordnik.swagger.core.util.JsonUtil;
import com.wordnik.swagger.model.ApiListing;
import com.wordnik.swagger.model.ApiListingReference;
import com.wordnik.swagger.model.ResourceListing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

public abstract class AbstractDocumentSource {
    protected final LogAdapter LOG;
    private final String outputPath;
    private final String templatePath;
    private final String mustacheFileRoot;
    private final String swaggerPath;
    protected ResourceListing serviceDocument;
    java.util.List<ApiListing> validDocuments = new ArrayList<ApiListing>();
    private String basePath;
    private String apiVersion;
    private ObjectMapper mapper = new ObjectMapper();
    private OutputTemplate outputTemplate;
    private boolean useOutputFlatStructure;

    public AbstractDocumentSource(LogAdapter logAdapter, String outputPath, String outputTpl, String swaggerOutput, String mustacheFileRoot, boolean useOutputFlatStructure1) {
        this.LOG = logAdapter;
        this.outputPath = outputPath;
        this.templatePath = outputTpl;
        this.mustacheFileRoot = mustacheFileRoot;
        this.useOutputFlatStructure = useOutputFlatStructure1;
        this.swaggerPath = swaggerOutput;
    }

    public abstract void loadDocuments() throws Exception, GenerateException;

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public OutputTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    protected void acceptDocument(ApiListing doc) {
        ApiListing newDoc = new ApiListing(doc.apiVersion(), doc.swaggerVersion(), this.basePath, doc.resourcePath(), doc.produces(), doc.consumes(), doc.protocols(), doc.authorizations(), doc.apis(), doc.models(), doc.description(), doc.position());
        this.validDocuments.add(newDoc);
    }

    public java.util.List<ApiListing> getValidDocuments() {
        return this.validDocuments;
    }

    public void toSwaggerDocuments() throws GenerateException {
        if (this.swaggerPath == null) {
            return;
        }
        File dir = new File(this.swaggerPath);
        if (dir.isFile()) {
            throw new GenerateException(String.format("Swagger-outputDirectory[%s] must be a directory!", this.swaggerPath));
        }
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                throw new GenerateException(String.format("Create Swagger-outputDirectory[%s] failed.", this.swaggerPath));
            }
        }
        this.cleanupOlds(dir);
        this.prepareServiceDocument();
        this.writeInDirectory(dir, this.serviceDocument);
        for (ApiListing doc : this.validDocuments) {
            this.writeInDirectory(dir, doc);
        }
    }

    private void cleanupOlds(File dir) {
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (!f.getName().endsWith("json")) continue;
                f.delete();
            }
        }
    }

    private void prepareServiceDocument() {
        ArrayList<ApiListingReference> apiListingReferences = new ArrayList<ApiListingReference>();
        for (ApiListingReference apiListingReference : this.serviceDocument.apis()) {
            String newPath = apiListingReference.path();
            if (this.useOutputFlatStructure && (newPath = newPath.replaceAll("/", "_")).startsWith("_")) {
                newPath = "/" + newPath.substring(1);
            }
            newPath = newPath + ".{format}";
            apiListingReferences.add(new ApiListingReference(newPath, apiListingReference.description(), apiListingReference.position()));
        }
        this.serviceDocument = new ResourceListing(this.serviceDocument.apiVersion(), this.serviceDocument.swaggerVersion(), List.fromIterator((Iterator)JavaConversions.asScalaIterator(apiListingReferences.iterator())), this.serviceDocument.authorizations(), this.serviceDocument.info());
    }

    protected String resourcePathToFilename(String resourcePath) {
        if (resourcePath == null) {
            return "service.json";
        }
        String name = resourcePath;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (this.useOutputFlatStructure) {
            name = name.replaceAll("/", "_");
        }
        return name + ".json";
    }

    private void writeInDirectory(File dir, ApiListing apiListing) throws GenerateException {
        String filename = this.resourcePathToFilename(apiListing.resourcePath());
        try {
            File serviceFile = this.createFile(dir, filename);
            String json = JsonSerializer.asJson((Object)apiListing);
            JsonNode tree = this.mapper.readTree(json);
            JsonUtil.mapper().writerWithDefaultPrettyPrinter().writeValue(serviceFile, (Object)tree);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    private void writeInDirectory(File dir, ResourceListing resourceListing) throws GenerateException {
        String filename = this.resourcePathToFilename(null);
        try {
            File serviceFile = this.createFile(dir, filename);
            String json = JsonSerializer.asJson((Object)resourceListing);
            JsonNode tree = this.mapper.readTree(json);
            JsonUtil.mapper().writerWithDefaultPrettyPrinter().writeValue(serviceFile, (Object)tree);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    protected File createFile(File dir, String outputResourcePath) throws IOException {
        File serviceFile;
        int i = outputResourcePath.lastIndexOf("/");
        if (i != -1) {
            String fileName = outputResourcePath.substring(i + 1);
            String subDir = outputResourcePath.substring(0, i);
            File finalDirectory = new File(dir, subDir);
            finalDirectory.mkdirs();
            serviceFile = new File(finalDirectory, fileName);
        } else {
            serviceFile = new File(dir, outputResourcePath);
        }
        while (!serviceFile.createNewFile()) {
            serviceFile.delete();
        }
        this.LOG.info("Creating file " + serviceFile.getAbsolutePath());
        return serviceFile;
    }

    public OutputTemplate prepareMustacheTemplate() throws GenerateException {
        this.outputTemplate = new OutputTemplate(this);
        return this.outputTemplate;
    }

    public void toDocuments() throws GenerateException {
        FileOutputStream fileOutputStream;
        if (this.outputTemplate == null) {
            this.prepareMustacheTemplate();
        }
        if (this.outputTemplate.getApiDocuments().isEmpty()) {
            this.LOG.warn("nothing to write.");
            return;
        }
        this.LOG.info("Writing doc to " + this.outputPath + "...");
        try {
            fileOutputStream = new FileOutputStream(this.outputPath);
        }
        catch (FileNotFoundException e) {
            throw new GenerateException(e);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
        try {
            URL url = this.getTemplateUri().toURL();
            InputStreamReader reader = new InputStreamReader(url.openStream(), Charset.forName("UTF-8"));
            Mustache mustache = this.getMustacheFactory().compile((Reader)reader, this.templatePath);
            mustache.execute((Writer)writer, (Object)this.outputTemplate).flush();
            writer.close();
            this.LOG.info("Done!");
        }
        catch (MalformedURLException e) {
            throw new GenerateException(e);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    private URI getTemplateUri() throws GenerateException {
        URI uri;
        try {
            uri = new URI(this.templatePath);
        }
        catch (URISyntaxException e) {
            File file = new File(this.templatePath);
            if (!file.exists()) {
                throw new GenerateException("Template " + file.getAbsoluteFile() + " not found. You can go to https://github.com/kongchen/api-doc-template to get templates.");
            }
            uri = file.toURI();
        }
        if (!uri.isAbsolute()) {
            File file = new File(this.templatePath);
            if (!file.exists()) {
                throw new GenerateException("Template " + file.getAbsoluteFile() + " not found. You can go to https://github.com/kongchen/api-doc-template to get templates.");
            }
            uri = new File(this.templatePath).toURI();
        }
        return uri;
    }

    private DefaultMustacheFactory getMustacheFactory() {
        if (this.mustacheFileRoot == null) {
            return new DefaultMustacheFactory();
        }
        return new DefaultMustacheFactory(new File(this.mustacheFileRoot));
    }
}

