/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    @Deprecated
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{UUIDDeserializer.instance, URLDeserializer.instance, URIDeserializer.instance, FileDeserializer.instance, CurrencyDeserializer.instance, PatternDeserializer.instance, LocaleDeserializer.instance, InetAddressDeserializer.instance, CharsetDeserializer.instance, AtomicBooleanDeserializer.instance, ClassDeserializer.instance, StackTraceElementDeserializer.instance};
    }

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (!_classNames.contains(clsName)) {
            return null;
        }
        if (rawType == URI.class) {
            return URIDeserializer.instance;
        }
        if (rawType == URL.class) {
            return URLDeserializer.instance;
        }
        if (rawType == File.class) {
            return FileDeserializer.instance;
        }
        if (rawType == UUID.class) {
            return UUIDDeserializer.instance;
        }
        if (rawType == Currency.class) {
            return CurrencyDeserializer.instance;
        }
        if (rawType == Pattern.class) {
            return PatternDeserializer.instance;
        }
        if (rawType == Locale.class) {
            return LocaleDeserializer.instance;
        }
        if (rawType == InetAddress.class) {
            return InetAddressDeserializer.instance;
        }
        if (rawType == Charset.class) {
            return CharsetDeserializer.instance;
        }
        if (rawType == Class.class) {
            return ClassDeserializer.instance;
        }
        if (rawType == StackTraceElement.class) {
            return StackTraceElementDeserializer.instance;
        }
        if (rawType == AtomicBoolean.class) {
            return AtomicBooleanDeserializer.instance;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clsName);
    }

    static {
        Class[] numberTypes;
        _classNames = new HashSet();
        for (Class cls : numberTypes = new Class[]{UUID.class, URL.class, URI.class, File.class, Currency.class, Pattern.class, Locale.class, InetAddress.class, Charset.class, AtomicBoolean.class, Class.class, StackTraceElement.class}) {
            _classNames.add(cls.getName());
        }
    }

    public static class StackTraceElementDeserializer
    extends StdScalarDeserializer<StackTraceElement> {
        public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

        public StackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        @Override
        public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                String className = "";
                String methodName = "";
                String fileName = "";
                int lineNumber = -1;
                while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                    String propName = jp.getCurrentName();
                    if ("className".equals(propName)) {
                        className = jp.getText();
                        continue;
                    }
                    if ("fileName".equals(propName)) {
                        fileName = jp.getText();
                        continue;
                    }
                    if ("lineNumber".equals(propName)) {
                        if (t.isNumeric()) {
                            lineNumber = jp.getIntValue();
                            continue;
                        }
                        throw JsonMappingException.from(jp, "Non-numeric token (" + t + ") for property 'lineNumber'");
                    }
                    if ("methodName".equals(propName)) {
                        methodName = jp.getText();
                        continue;
                    }
                    if ("nativeMethod".equals(propName)) continue;
                    this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
                }
                return new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            throw ctxt.mappingException(this._valueClass, t);
        }
    }

    public static class AtomicBooleanDeserializer
    extends StdScalarDeserializer<AtomicBoolean> {
        public static final AtomicBooleanDeserializer instance = new AtomicBooleanDeserializer();

        public AtomicBooleanDeserializer() {
            super(AtomicBoolean.class);
        }

        @Override
        public AtomicBoolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new AtomicBoolean(this._parseBooleanPrimitive(jp, ctxt));
        }
    }

    public static class AtomicReferenceDeserializer
    extends StdScalarDeserializer<AtomicReference<?>>
    implements ContextualDeserializer {
        protected final JavaType _referencedType;
        protected final JsonDeserializer<?> _valueDeserializer;

        public AtomicReferenceDeserializer(JavaType referencedType) {
            this(referencedType, null);
        }

        public AtomicReferenceDeserializer(JavaType referencedType, JsonDeserializer<?> deser) {
            super(AtomicReference.class);
            this._referencedType = referencedType;
            this._valueDeserializer = deser;
        }

        @Override
        public AtomicReference<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new AtomicReference(this._valueDeserializer.deserialize(jp, ctxt));
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JsonDeserializer<?> deser = this._valueDeserializer;
            if (deser != null) {
                return this;
            }
            return new AtomicReferenceDeserializer(this._referencedType, ctxt.findContextualValueDeserializer(this._referencedType, property));
        }
    }

    public static class FileDeserializer
    extends FromStringDeserializer<File> {
        public static final FileDeserializer instance = new FileDeserializer();

        public FileDeserializer() {
            super(File.class);
        }

        @Override
        protected File _deserialize(String value, DeserializationContext ctxt) {
            return new File(value);
        }
    }

    protected static class CharsetDeserializer
    extends FromStringDeserializer<Charset> {
        public static final CharsetDeserializer instance = new CharsetDeserializer();

        public CharsetDeserializer() {
            super(Charset.class);
        }

        @Override
        protected Charset _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return Charset.forName(value);
        }
    }

    protected static class InetAddressDeserializer
    extends FromStringDeserializer<InetAddress> {
        public static final InetAddressDeserializer instance = new InetAddressDeserializer();

        public InetAddressDeserializer() {
            super(InetAddress.class);
        }

        @Override
        protected InetAddress _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return InetAddress.getByName(value);
        }
    }

    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public static final LocaleDeserializer instance = new LocaleDeserializer();

        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String value, DeserializationContext ctxt) throws IOException {
            int ix = value.indexOf(95);
            if (ix < 0) {
                return new Locale(value);
            }
            String first = value.substring(0, ix);
            if ((ix = (value = value.substring(ix + 1)).indexOf(95)) < 0) {
                return new Locale(first, value);
            }
            String second = value.substring(0, ix);
            return new Locale(first, second, value.substring(ix + 1));
        }
    }

    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public static final PatternDeserializer instance = new PatternDeserializer();

        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Pattern.compile(value);
        }
    }

    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public static final CurrencyDeserializer instance = new CurrencyDeserializer();

        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return Currency.getInstance(value);
        }
    }

    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public static final URIDeserializer instance = new URIDeserializer();

        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return URI.create(value);
        }
    }

    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public static final URLDeserializer instance = new URLDeserializer();

        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return new URL(value);
        }
    }

    public static class UUIDDeserializer
    extends FromStringDeserializer<UUID> {
        public static final UUIDDeserializer instance = new UUIDDeserializer();

        public UUIDDeserializer() {
            super(UUID.class);
        }

        @Override
        protected UUID _deserialize(String value, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return UUID.fromString(value);
        }

        @Override
        protected UUID _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (ob instanceof byte[]) {
                byte[] bytes = (byte[])ob;
                if (bytes.length != 16) {
                    ctxt.mappingException("Can only construct UUIDs from 16 byte arrays; got " + bytes.length + " bytes");
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
                long l1 = in.readLong();
                long l2 = in.readLong();
                return new UUID(l1, l2);
            }
            super._deserializeEmbedded(ob, ctxt);
            return null;
        }
    }
}

