/*
 * Decompiled with CFR 0.152.
 */
package com.devsu.push.sender.service.sync;

import com.devsu.push.sender.service.sync.SyncPushService;
import java.util.Map;
import org.slf4j.Logger;

public abstract class SyncPushServiceBase
implements SyncPushService {
    protected boolean pushEnabled;

    public boolean validateSingleData(Logger log, String message, String token) {
        if (message == null) {
            log.error("Message is null.");
            return false;
        }
        if (token == null) {
            log.error("Token is null.");
            return false;
        }
        if (!this.pushEnabled) {
            log.debug("PUSH MOCK - " + token + ": " + message);
            return false;
        }
        return true;
    }

    public boolean validateBulkData(Logger log, String message) {
        if (message == null) {
            log.error("Message is null.");
            return false;
        }
        if (!this.pushEnabled) {
            log.debug("BULK PUSH MOCK - " + message);
            return false;
        }
        return true;
    }

    @Override
    public boolean sendPush(String message, String token) throws Exception {
        return this.sendPush(null, message, null, token);
    }

    @Override
    public boolean sendPush(String title, String message, String token) throws Exception {
        return this.sendPush(title, message, null, token);
    }

    @Override
    public boolean sendPushInBulk(String message, String ... tokens) throws Exception {
        return this.sendPushInBulk((String)null, message, (Map<String, String>)null, tokens);
    }

    @Override
    public boolean sendPushInBulk(String title, String message, String ... tokens) throws Exception {
        return this.sendPushInBulk(title, message, (Map<String, String>)null, tokens);
    }

    public void setPushEnabled(boolean pushEnabled) {
        this.pushEnabled = pushEnabled;
    }
}

