/*
 * Decompiled with CFR 0.152.
 */
package com.devsu.push.sender.service.sync;

import com.devsu.push.sender.service.sync.SyncPushServiceBase;
import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.PayloadBuilder;
import com.notnoop.exceptions.InvalidSSLConfig;
import com.notnoop.exceptions.RuntimeIOException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncApplePushService
extends SyncPushServiceBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApnsService apnsService;

    public SyncApplePushService(String certificatePath, String certificatePassword, boolean useProductionServer) throws RuntimeIOException, InvalidSSLConfig {
        this.setDefaultValues();
        if (useProductionServer) {
            this.setupProductionServer(certificatePath, certificatePassword);
        } else {
            this.setupDevelopmentServer(certificatePath, certificatePassword);
        }
    }

    private void setDefaultValues() {
        this.pushEnabled = true;
    }

    @Override
    public boolean sendPush(String title, String message, Map<String, String> additionalFields, String token) throws Exception {
        if (!this.validateSingleData(this.log, message, token)) {
            return false;
        }
        this.apnsService.start();
        PayloadBuilder msgBuilder = this.generateBuilder(title, message, additionalFields);
        this.apnsService.push(token, msgBuilder.build());
        this.apnsService.stop();
        return true;
    }

    @Override
    public boolean sendPushInBulk(String title, String message, Map<String, String> additionalFields, String ... tokens) {
        if (!this.validateBulkData(this.log, message)) {
            return false;
        }
        this.apnsService.start();
        PayloadBuilder msgBuilder = this.generateBuilder(title, message, additionalFields);
        this.apnsService.push(Arrays.asList(tokens), msgBuilder.build());
        this.apnsService.stop();
        return true;
    }

    private PayloadBuilder generateBuilder(String title, String message, Map<String, String> additionalFields) {
        PayloadBuilder msgBuilder = APNS.newPayload().alertBody(message).sound("default");
        if (title != null) {
            msgBuilder.alertTitle(title);
        }
        if (additionalFields == null) {
            return msgBuilder;
        }
        msgBuilder.customFields(additionalFields);
        return msgBuilder;
    }

    public void setupDevelopmentServer(String certificatePath, String certificatePassword) throws RuntimeIOException, InvalidSSLConfig {
        this.apnsService = APNS.newService().withCert(certificatePath, certificatePassword).withSandboxDestination().build();
        this.apnsService.stop();
    }

    public void setupProductionServer(String certificatePath, String certificatePassword) throws RuntimeIOException, InvalidSSLConfig {
        this.apnsService = APNS.newService().withCert(certificatePath, certificatePassword).withProductionDestination().build();
        this.apnsService.stop();
    }

    private static class Defaults {
        private static final boolean PUSH_ENABLED = true;
        private static final String SOUND = "default";

        private Defaults() {
        }
    }
}

