/*
 * Decompiled with CFR 0.152.
 */
package com.devsu.push.sender.service.sync;

import com.devsu.push.sender.service.sync.SyncPushServiceBase;
import com.devsu.push.sender.util.ArrayUtil;
import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Result;
import com.google.android.gcm.server.Sender;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncAndroidPushService
extends SyncPushServiceBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int maxRetries;
    private String messageKey;
    private String titleKey;
    private int maxBulkSize;
    private String collapseKeySingle;
    private String collapseKeyBulk;
    private Sender senderService;

    public SyncAndroidPushService(String gcmApiKey) {
        this.setDefaultValues();
        this.senderService = new Sender(gcmApiKey);
    }

    private void setDefaultValues() {
        this.maxRetries = 3;
        this.messageKey = "message";
        this.titleKey = "title";
        this.maxBulkSize = 1000;
        this.collapseKeySingle = "single";
        this.collapseKeyBulk = "bulk";
        this.pushEnabled = true;
    }

    @Override
    public boolean sendPush(String title, String message, Map<String, String> additionalFields, String token) throws IOException {
        if (!this.validateSingleData(this.log, message, token)) {
            return false;
        }
        Message.Builder msgBuilder = this.generateBuilder(title, message, true, additionalFields);
        Result result = this.senderService.send(msgBuilder.build(), token, this.maxRetries);
        return this.resultIsOk(result);
    }

    @Override
    public boolean sendPushInBulk(String title, String message, Map<String, String> additionalFields, String ... tokens) throws IOException {
        if (!this.validateBulkData(this.log, message)) {
            return false;
        }
        boolean booleanResult = true;
        List<String[]> tokenLimitedList = ArrayUtil.splitArray(tokens, this.maxBulkSize);
        for (String[] tokenArray : tokenLimitedList) {
            Message.Builder msgBuilder = this.generateBuilder(title, message, false, additionalFields);
            MulticastResult result = this.senderService.send(msgBuilder.build(), Arrays.asList(tokenArray), this.maxRetries);
            boolean bl = booleanResult = booleanResult ? this.resultIsOk(result) : false;
        }
        return booleanResult;
    }

    private Message.Builder generateBuilder(String title, String message, boolean isSingle, Map<String, String> additionalFields) {
        String collapseKey = isSingle ? this.collapseKeySingle : this.collapseKeyBulk;
        Message.Builder msgBuilder = new Message.Builder().addData(this.messageKey, message).collapseKey(collapseKey);
        if (title != null) {
            msgBuilder.addData(this.titleKey, title);
        }
        if (additionalFields == null) {
            return msgBuilder;
        }
        for (Map.Entry<String, String> entry : additionalFields.entrySet()) {
            msgBuilder.addData(entry.getKey(), entry.getValue());
        }
        return msgBuilder;
    }

    private boolean resultIsOk(Result result) {
        if (result.getErrorCodeName() == null || result.getErrorCodeName().isEmpty()) {
            return true;
        }
        this.log.error("Error occurred while sending push notification :" + result.getErrorCodeName());
        return false;
    }

    private boolean resultIsOk(MulticastResult result) {
        boolean isOk;
        boolean bl = isOk = result.getResults() == null || result.getResults().isEmpty();
        if (result.getResults() != null) {
            for (Result myResult : result.getResults()) {
                this.resultIsOk(myResult);
            }
        }
        return isOk;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setMaxBulkSize(int maxBulkSize) {
        this.maxBulkSize = maxBulkSize > 1000 ? 1000 : maxBulkSize;
    }

    public void setCollapseKeySingle(String collapseKeySingle) {
        this.collapseKeySingle = collapseKeySingle;
    }

    public void setCollapseKeyBulk(String collapseKeyBulk) {
        this.collapseKeyBulk = collapseKeyBulk;
    }

    public void setGcmApiKey(String gcmApiKey) {
        this.senderService = new Sender(gcmApiKey);
    }

    private static class Defaults {
        private static final int MAX_RETRIES = 3;
        private static final String MESSAGE_KEY = "message";
        private static final String TITLE_KEY = "title";
        private static final int MAX_BULK_SIZE = 1000;
        private static final String COLLAPSE_KEY_SINGLE = "single";
        private static final String COLLAPSE_KEY_BULK = "bulk";
        private static final boolean PUSH_ENABLED = true;

        private Defaults() {
        }
    }
}

