/*
 * Decompiled with CFR 0.152.
 */
package com.devsu.push.sender.service.async;

import com.devsu.push.sender.callback.PushCallback;
import com.devsu.push.sender.service.async.AsyncPushService;
import com.devsu.push.sender.service.sync.SyncPushService;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AsyncPushServiceBase
implements AsyncPushService {
    protected SyncPushService pushService;
    protected PushCallback pushCallback;

    protected AsyncPushServiceBase(SyncPushService pushService, PushCallback pushCallback) {
        this.pushService = pushService;
        this.pushCallback = pushCallback;
    }

    @Override
    public void sendPush(String message, String token) {
        this.sendPush(null, message, null, token);
    }

    @Override
    public void sendPush(String title, String message, String token) {
        this.sendPush(title, message, null, token);
    }

    @Override
    public void sendPush(final String title, final String message, final Map<String, String> additionalFields, final String token) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        boolean result = AsyncPushServiceBase.this.pushService.sendPush(title, message, additionalFields, token);
                        if (AsyncPushServiceBase.this.pushCallback != null) {
                            AsyncPushServiceBase.this.pushCallback.onSingleSuccess(result, title, message, additionalFields, token);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncPushServiceBase.this.pushCallback == null) break block3;
                        AsyncPushServiceBase.this.pushCallback.onError(e);
                    }
                }
            }
        });
        executorService.shutdown();
    }

    @Override
    public void sendPushInBulk(String message, String ... tokens) {
        this.sendPushInBulk((String)null, message, (Map<String, String>)null, tokens);
    }

    @Override
    public void sendPushInBulk(String title, String message, String ... tokens) {
        this.sendPushInBulk(title, message, (Map<String, String>)null, tokens);
    }

    @Override
    public void sendPushInBulk(final String title, final String message, final Map<String, String> additionalFields, final String ... tokens) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        boolean result = AsyncPushServiceBase.this.pushService.sendPushInBulk(title, message, additionalFields, tokens);
                        if (AsyncPushServiceBase.this.pushCallback != null) {
                            AsyncPushServiceBase.this.pushCallback.onBulkSuccess(result, title, message, additionalFields, tokens);
                        }
                    }
                    catch (Exception e) {
                        if (AsyncPushServiceBase.this.pushCallback == null) break block3;
                        AsyncPushServiceBase.this.pushCallback.onError(e);
                    }
                }
            }
        });
        executorService.shutdown();
    }

    @Override
    public void setPushCallback(PushCallback pushCallback) {
        this.pushCallback = pushCallback;
    }
}

