/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures.collections.iterators;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.subdoc.MultiMutationException;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@InterfaceStability.Committed
@InterfaceAudience.Private
public class JsonArrayDocumentIterator<E>
implements Iterator<E> {
    private final Bucket bucket;
    private final String id;
    private long cas;
    private final Iterator<E> delegate;
    private int lastVisited = -1;
    private boolean doneRemove = false;

    public JsonArrayDocumentIterator(Bucket bucket, String id) {
        this.bucket = bucket;
        this.id = id;
        JsonArrayDocument current = bucket.get(id, JsonArrayDocument.class);
        this.cas = current.cas();
        this.delegate = ((JsonArray)current.content()).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            ++this.lastVisited;
            this.doneRemove = false;
        }
        return this.delegate.next();
    }

    @Override
    public void remove() {
        if (this.lastVisited < 0) {
            throw new IllegalStateException("Cannot remove before having started iterating");
        }
        if (this.doneRemove) {
            throw new IllegalStateException("Cannot remove twice in a row while iterating");
        }
        String path = "[" + this.lastVisited + "]";
        try {
            DocumentFragment<Mutation> itrRemoveResult = this.bucket.mutateIn(this.id).withCas(this.cas).remove(path).execute();
            this.cas = itrRemoveResult.cas();
            this.delegate.remove();
            this.doneRemove = true;
            --this.lastVisited;
        }
        catch (CASMismatchException e) {
            throw new ConcurrentModificationException("Couldn't remove while iterating: " + (Object)((Object)e));
        }
        catch (MultiMutationException e) {
            if (e.firstFailureStatus() == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                throw new IllegalStateException("Invalid remove index " + path);
            }
            throw e;
        }
    }
}

