/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.auth;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.auth.Authenticator;
import com.couchbase.client.java.auth.Credential;
import com.couchbase.client.java.auth.CredentialContext;
import java.util.Collections;
import java.util.List;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class PasswordAuthenticator
implements Authenticator {
    private final String username;
    private final String password;

    public PasswordAuthenticator(String password) {
        this.username = null;
        this.password = password;
    }

    public PasswordAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public List<Credential> getCredentials(CredentialContext context, String specific) {
        return Collections.singletonList(new Credential(this.username, this.password));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }
}

