/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster.api;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.config.RestApiRequest;
import com.couchbase.client.core.message.config.RestApiResponse;
import com.couchbase.client.core.utils.Blocking;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.java.cluster.api.AsyncRestBuilder;
import com.couchbase.client.java.cluster.api.Form;
import com.couchbase.client.java.cluster.api.RestBuilderMarker;
import com.couchbase.client.java.document.json.JsonValue;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class RestBuilder
implements RestBuilderMarker {
    private final AsyncRestBuilder delegate;
    private final long defaultTimeout;
    private final TimeUnit defaultTimeUnit;

    public RestBuilder(AsyncRestBuilder asyncBuilder, long defaultTimeout, TimeUnit defaultTimeUnit) {
        this.delegate = asyncBuilder;
        this.defaultTimeout = defaultTimeout;
        this.defaultTimeUnit = defaultTimeUnit;
    }

    public RestBuilder withParam(String key, String value) {
        this.delegate.withParam(key, value);
        return this;
    }

    public RestBuilder contentType(String type) {
        this.delegate.contentType(type);
        return this;
    }

    public RestBuilder withHeader(String key, Object value) {
        this.delegate.withHeader(key, value);
        return this;
    }

    public RestBuilder body(String jsonBody) {
        this.delegate.body(jsonBody);
        return this;
    }

    public RestBuilder body(JsonValue jsonBody) {
        this.delegate.body(jsonBody);
        return this;
    }

    public RestBuilder bodyRaw(String body) {
        this.delegate.bodyRaw(body);
        return this;
    }

    public RestBuilder accept(String type) {
        this.delegate.accept(type);
        return this;
    }

    public RestBuilder bodyForm(Form form) {
        this.delegate.bodyForm(form);
        return this;
    }

    public HttpMethod method() {
        return this.delegate.method();
    }

    public String path() {
        return this.delegate.path();
    }

    public Map<String, String> params() {
        return this.delegate.params();
    }

    public Map<String, Object> headers() {
        return this.delegate.headers();
    }

    public String body() {
        return this.delegate.body();
    }

    public RestApiRequest asRequest() {
        return this.delegate.asRequest();
    }

    public RestApiResponse execute(long timeout, TimeUnit timeUnit) {
        return (RestApiResponse)Blocking.blockForSingle(this.delegate.execute(), (long)timeout, (TimeUnit)timeUnit);
    }

    public RestApiResponse execute() {
        return this.execute(this.defaultTimeout, this.defaultTimeUnit);
    }
}

