/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.sax;

import com.couchbase.client.deps.com.fasterxml.aalto.sax.SAXFeature;
import com.couchbase.client.deps.com.fasterxml.aalto.sax.SAXProperty;
import java.util.HashMap;
import org.xml.sax.SAXNotRecognizedException;

public final class SAXUtil {
    static final HashMap<String, SAXFeature> sStdFeatures;
    static final HashMap<String, SAXProperty> sStdProperties;

    private SAXUtil() {
    }

    public static SAXFeature findStdFeature(String featURI) {
        if (featURI.startsWith("http://xml.org/sax/features/")) {
            String suffix = featURI.substring("http://xml.org/sax/features/".length());
            return sStdFeatures.get(suffix);
        }
        return null;
    }

    public static SAXProperty findStdProperty(String featURI) {
        if (featURI.startsWith("http://xml.org/sax/properties/")) {
            String suffix = featURI.substring("http://xml.org/sax/properties/".length());
            return sStdProperties.get(suffix);
        }
        return null;
    }

    public static Boolean getFixedStdFeatureValue(SAXFeature stdFeat) {
        switch (stdFeat) {
            case EXTERNAL_GENERAL_ENTITIES: {
                return Boolean.FALSE;
            }
            case EXTERNAL_PARAMETER_ENTITIES: {
                return Boolean.FALSE;
            }
            case IS_STANDALONE: {
                break;
            }
            case LEXICAL_HANDLER_PARAMETER_ENTITIES: {
                return Boolean.TRUE;
            }
            case NAMESPACES: {
                return Boolean.TRUE;
            }
            case NAMESPACE_PREFIXES: {
                return Boolean.FALSE;
            }
            case RESOLVE_DTD_URIS: {
                return Boolean.FALSE;
            }
            case STRING_INTERNING: {
                return Boolean.TRUE;
            }
            case UNICODE_NORMALIZATION_CHECKING: {
                return Boolean.FALSE;
            }
            case USE_ATTRIBUTES2: 
            case USE_LOCATOR2: 
            case USE_ENTITY_RESOLVER2: {
                return Boolean.TRUE;
            }
            case VALIDATION: {
                return Boolean.FALSE;
            }
            case XMLNS_URIS: {
                return Boolean.TRUE;
            }
            case XML_1_1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static void reportUnknownFeature(String name) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Feature '" + name + "' not recognized");
    }

    public static void reportUnknownProperty(String name) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Property '" + name + "' not recognized");
    }

    static {
        SAXFeature[] feats = SAXFeature.values();
        sStdFeatures = new HashMap(feats.length);
        for (SAXFeature sAXFeature : feats) {
            sStdFeatures.put(sAXFeature.getSuffix(), sAXFeature);
        }
        SAXProperty[] props = SAXProperty.values();
        sStdProperties = new HashMap(props.length);
        for (Enum enum_ : props) {
            sStdProperties.put(((SAXProperty)enum_).getSuffix(), (SAXProperty)enum_);
        }
    }
}

