/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.out;

import com.couchbase.client.deps.com.fasterxml.aalto.util.XmlCharTypes;
import com.couchbase.client.deps.com.fasterxml.aalto.util.XmlChars;

public final class OutputCharTypes
extends XmlCharTypes {
    static final int MAIN_TABLE_SIZE = 2048;
    public static final int CT_OUTPUT_MUST_QUOTE = 4;
    public static final int CT_OUTPUT_NAME_UNENCODABLE = 4;
    public static final int CT_OUTPUT_NAME_NONFIRST_MB2 = 5;
    public static final int CT_OUTPUT_NAME_ANY_MB2 = 6;
    private static XmlCharTypes sAsciiCharTypes = null;
    private static XmlCharTypes sLatin1CharTypes = null;
    private static final XmlCharTypes sUtf8CharTypes = new XmlCharTypes(2048);

    public static final XmlCharTypes getUtf8CharTypes() {
        return sUtf8CharTypes;
    }

    public static final XmlCharTypes getLatin1CharTypes() {
        if (sLatin1CharTypes == null) {
            sLatin1CharTypes = new XmlCharTypes(2048);
            OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS, OutputCharTypes.sLatin1CharTypes.ATTR_CHARS, OutputCharTypes.sLatin1CharTypes.NAME_CHARS, OutputCharTypes.sLatin1CharTypes.DTD_CHARS, OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.DTD_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
        }
        return sLatin1CharTypes;
    }

    public static final XmlCharTypes getAsciiCharTypes() {
        if (sAsciiCharTypes == null) {
            sAsciiCharTypes = new XmlCharTypes(2048);
            OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sAsciiCharTypes.TEXT_CHARS, OutputCharTypes.sAsciiCharTypes.ATTR_CHARS, OutputCharTypes.sAsciiCharTypes.NAME_CHARS, OutputCharTypes.sAsciiCharTypes.DTD_CHARS, OutputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.TEXT_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.ATTR_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.DTD_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            OutputCharTypes.modifyAsciiNames(OutputCharTypes.sAsciiCharTypes.NAME_CHARS);
            OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sAsciiCharTypes.ATTR_CHARS);
        }
        return sAsciiCharTypes;
    }

    private static void modifyForLatin1(int[] charTable) {
        for (int i = 127; i <= 159; ++i) {
            charTable[i] = 4;
        }
        OutputCharTypes.requireQuotingAfter(charTable, 255);
    }

    private static void modifyLatin1Names(int[] charTable) {
        int len = charTable.length;
        for (int i = 256; i < len; ++i) {
            int val = charTable[i];
            if (val != 2 && val != 3) continue;
            charTable[i] = 4;
        }
    }

    private static void modifyForUtf8(int[] charTable) {
        int len = charTable.length;
        for (int i = 128; i < len; ++i) {
            if (charTable[i] != 0) continue;
            charTable[i] = 5;
        }
    }

    private static void modifyUtf8Names(int[] charTable) {
        int len = charTable.length;
        for (int i = 128; i < len; ++i) {
            charTable[i] = XmlChars.is10NameStartChar(i) ? 6 : (XmlChars.is10NameChar(i) ? 5 : 0);
        }
    }

    private static void modifyForAscii(int[] charTable) {
        OutputCharTypes.requireQuotingAfter(charTable, 127);
    }

    private static void modifyAsciiNames(int[] charTable) {
        OutputCharTypes.modifyLatin1Names(charTable);
        int len = charTable.length;
        for (int i = 128; i < len; ++i) {
            int val = charTable[i];
            if (val != 2 && val != 3) continue;
            charTable[i] = 4;
        }
    }

    private static void modifyForAttrWrite(int[] charTable) {
        charTable[9] = 4;
    }

    private static void requireQuotingAfter(int[] charTable, int lastValid) {
        int len = charTable.length;
        for (int i = lastValid + 1; i < len; ++i) {
            if (charTable[i] != 0) continue;
            charTable[i] = 4;
        }
    }

    static {
        OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS, OutputCharTypes.sUtf8CharTypes.ATTR_CHARS, OutputCharTypes.sUtf8CharTypes.NAME_CHARS, OutputCharTypes.sUtf8CharTypes.DTD_CHARS, OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.DTD_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyUtf8Names(OutputCharTypes.sUtf8CharTypes.NAME_CHARS);
        OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
    }
}

