/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.out;

import com.couchbase.client.deps.com.fasterxml.aalto.out.ByteWName;
import com.couchbase.client.deps.com.fasterxml.aalto.out.OutputCharTypes;
import com.couchbase.client.deps.com.fasterxml.aalto.out.SingleByteXmlWriter;
import com.couchbase.client.deps.com.fasterxml.aalto.out.WName;
import com.couchbase.client.deps.com.fasterxml.aalto.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class AsciiXmlWriter
extends SingleByteXmlWriter {
    static final int LAST_VALID_CHAR = 127;

    public AsciiXmlWriter(WriterConfig cfg, OutputStream out) {
        super(cfg, out, OutputCharTypes.getAsciiCharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 127;
    }

    @Override
    public void writeRaw(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null || len == 0) {
            return;
        }
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cbuf[offset]);
            ++offset;
            --len;
        }
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = cbuf[offset++]) > '\u007f') {
                this.reportFailedEscaping("raw content", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)ch;
        }
    }

    @Override
    protected WName doConstructName(String localName) throws XMLStreamException {
        return new ByteWName(localName, AsciiXmlWriter.getAscii(localName));
    }

    @Override
    protected WName doConstructName(String prefix, String localName) throws XMLStreamException {
        int plen = prefix.length();
        byte[] pname = new byte[plen + 1 + localName.length()];
        AsciiXmlWriter.getAscii(prefix, pname, 0);
        pname[plen] = 58;
        AsciiXmlWriter.getAscii(localName, pname, plen + 1);
        return new ByteWName(prefix, localName, pname);
    }
}

