/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.in;

import com.couchbase.client.deps.com.fasterxml.aalto.in.NsDeclaration;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.codehaus.stax2.ri.EmptyIterator;
import org.codehaus.stax2.ri.SingletonIterator;

public final class FixedNsContext
implements NamespaceContext {
    public static final FixedNsContext EMPTY_CONTEXT = new FixedNsContext(null, new String[0]);
    protected final NsDeclaration _lastDeclaration;
    protected final String[] _declarationData;
    protected ArrayList<String> _tmpDecl = null;

    private FixedNsContext(NsDeclaration lastDecl, String[] declData) {
        this._lastDeclaration = lastDecl;
        this._declarationData = declData;
    }

    public FixedNsContext reuseOrCreate(NsDeclaration currLastDecl) {
        if (currLastDecl == this._lastDeclaration) {
            return this;
        }
        if (this == EMPTY_CONTEXT) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (NsDeclaration curr = currLastDecl; curr != null; curr = curr.getPrev()) {
                tmp.add(curr.getPrefix());
                tmp.add(curr.getCurrNsURI());
            }
            return new FixedNsContext(currLastDecl, tmp.toArray(new String[tmp.size()]));
        }
        if (this._tmpDecl == null) {
            this._tmpDecl = new ArrayList();
        } else {
            this._tmpDecl.clear();
        }
        for (NsDeclaration curr = currLastDecl; curr != null; curr = curr.getPrev()) {
            this._tmpDecl.add(curr.getPrefix());
            this._tmpDecl.add(curr.getCurrNsURI());
        }
        return new FixedNsContext(currLastDecl, this._tmpDecl.toArray(new String[this._tmpDecl.size()]));
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Null prefix not allowed");
        }
        if (prefix.length() > 0) {
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        String[] ns = this._declarationData;
        int len = ns.length;
        for (int i = 0; i < len; i += 2) {
            if (!prefix.equals(ns[i])) continue;
            return ns[i + 1];
        }
        return null;
    }

    @Override
    public final String getPrefix(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        String[] ns = this._declarationData;
        int len = ns.length;
        block0: for (int i = 1; i < len; i += 2) {
            if (!nsURI.equals(ns[i])) continue;
            String prefix = ns[i - 1];
            for (int j = i + 1; j < len; j += 2) {
                if (ns[j] == prefix) continue block0;
            }
            return ns[i - 1];
        }
        return null;
    }

    public final Iterator<?> getPrefixes(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return SingletonIterator.create("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return SingletonIterator.create("xmlns");
        }
        String[] ns = this._declarationData;
        String first = null;
        ArrayList<String> all = null;
        int len = ns.length;
        block0: for (int i = 1; i < len; i += 2) {
            String currNS = ns[i];
            if (currNS != nsURI && !currNS.equals(nsURI)) continue;
            String prefix = ns[i - 1];
            for (int j = i + 1; j < len; j += 2) {
                if (ns[j] == prefix) continue block0;
            }
            if (first == null) {
                first = prefix;
                continue;
            }
            if (all == null) {
                all = new ArrayList<String>();
                all.add(first);
            }
            all.add(prefix);
        }
        if (all != null) {
            return all.iterator();
        }
        if (first != null) {
            return SingletonIterator.create(first);
        }
        return EmptyIterator.getInstance();
    }

    public String toString() {
        if (this == EMPTY_CONTEXT) {
            return "[EMPTY non-transient NsContext]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int len = this._declarationData.length;
        for (int i = 0; i < len; i += 2) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"').append(this._declarationData[i]).append("\"->\"");
            sb.append(this._declarationData[i + 1]).append('\"');
        }
        sb.append(']');
        return sb.toString();
    }
}

