/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.in;

import com.couchbase.client.deps.com.fasterxml.aalto.impl.ErrorConsts;
import com.couchbase.client.deps.com.fasterxml.aalto.impl.IoStreamException;
import com.couchbase.client.deps.com.fasterxml.aalto.impl.LocationImpl;
import com.couchbase.client.deps.com.fasterxml.aalto.in.InputBootstrapper;
import com.couchbase.client.deps.com.fasterxml.aalto.in.ReaderConfig;
import com.couchbase.client.deps.com.fasterxml.aalto.in.ReaderScanner;
import com.couchbase.client.deps.com.fasterxml.aalto.in.XmlScanner;
import com.couchbase.client.deps.com.fasterxml.aalto.util.CharsetNames;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class CharSourceBootstrapper
extends InputBootstrapper {
    static final int DEFAULT_BUFFER_SIZE = 4000;
    static final char CHAR_BOM_MARKER = '\ufeff';
    final Reader _in;
    final char[] _inputBuffer;
    private int _inputPtr;
    private int _inputLast;

    private CharSourceBootstrapper(ReaderConfig cfg, Reader r) {
        super(cfg);
        this._in = r;
        this._inputBuffer = cfg.allocFullCBuffer(4000);
        this._inputPtr = 0;
        this._inputLast = 0;
    }

    private CharSourceBootstrapper(ReaderConfig cfg, char[] buffer, int start, int len) {
        super(cfg);
        this._in = null;
        this._inputBuffer = buffer;
        this._inputPtr = start;
        this._inputLast = start + len;
    }

    public static CharSourceBootstrapper construct(ReaderConfig cfg, Reader r) throws XMLStreamException {
        return new CharSourceBootstrapper(cfg, r);
    }

    public static CharSourceBootstrapper construct(ReaderConfig cfg, char[] buffer, int start, int len) throws XMLStreamException {
        return new CharSourceBootstrapper(cfg, buffer, start, len);
    }

    @Override
    public final XmlScanner bootstrap() throws XMLStreamException {
        try {
            XmlScanner xmlScanner = this.doBootstrap();
            return xmlScanner;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        finally {
            this._config.freeSmallCBuffer(this.mKeyword);
        }
    }

    public XmlScanner doBootstrap() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.initialLoad(7);
        }
        String normEnc = null;
        if (this._inputLast - this._inputPtr >= 7) {
            char c = this._inputBuffer[this._inputPtr];
            if (c == '\ufeff') {
                c = this._inputBuffer[++this._inputPtr];
            }
            if (c == '<') {
                if (this._inputBuffer[this._inputPtr + 1] == '?' && this._inputBuffer[this._inputPtr + 2] == 'x' && this._inputBuffer[this._inputPtr + 3] == 'm' && this._inputBuffer[this._inputPtr + 4] == 'l' && this._inputBuffer[this._inputPtr + 5] <= ' ') {
                    this._inputPtr += 6;
                    this.readXmlDeclaration();
                    if (this.mFoundEncoding != null) {
                        normEnc = this.verifyXmlEncoding(this.mFoundEncoding);
                    }
                }
            } else if (c == '\u00ef') {
                throw new IoStreamException("Unexpected first character (char code 0xEF), not valid in xml document: could be mangled UTF-8 BOM marker. Make sure that the Reader uses correct encoding or pass an InputStream instead");
            }
        }
        this._config.setActualEncoding(normEnc);
        this._config.setXmlDeclInfo(this.mDeclaredXmlVersion, this.mFoundEncoding, this.mStandalone);
        return new ReaderScanner(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLast);
    }

    protected String verifyXmlEncoding(String enc) throws XMLStreamException {
        XMLReporter rep;
        enc = CharsetNames.normalize(enc);
        String extEnc = this._config.getExternalEncoding();
        if (extEnc != null && enc != null && !extEnc.equalsIgnoreCase(enc) && (rep = this._config.getXMLReporter()) != null) {
            Location loc = this.getLocation();
            rep.report(MessageFormat.format(ErrorConsts.W_MIXED_ENCODINGS, extEnc, enc), ErrorConsts.WT_XML_DECL, this, loc);
        }
        return enc;
    }

    protected boolean initialLoad(int minimum) throws IOException {
        this._inputPtr = 0;
        this._inputLast = 0;
        if (this._in == null) {
            return false;
        }
        while (this._inputLast < minimum) {
            int count = this._in.read(this._inputBuffer, this._inputLast, this._inputBuffer.length - this._inputLast);
            if (count < 1) {
                return false;
            }
            this._inputLast += count;
        }
        return true;
    }

    protected void loadMore() throws IOException, XMLStreamException {
        this._inputProcessed += this._inputLast;
        this._inputRowStart -= this._inputLast;
        if (this._in == null) {
            this.reportEof();
        }
        this._inputPtr = 0;
        this._inputLast = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (this._inputLast < 1) {
            this.reportEof();
        }
    }

    @Override
    protected void pushback() {
        --this._inputPtr;
    }

    @Override
    protected int getNext() throws IOException, XMLStreamException {
        return this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
    }

    @Override
    protected int getNextAfterWs(boolean reqWs) throws IOException, XMLStreamException {
        int count = 0;
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c > ' ') {
                if (reqWs && count == 0) {
                    this.reportUnexpectedChar(c, "; expected a white space");
                }
                return c;
            }
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            ++count;
        }
    }

    @Override
    protected int checkKeyword(String exp) throws IOException, XMLStreamException {
        int len = exp.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c != exp.charAt(ptr)) {
                return c;
            }
            if (c != '\u0000') continue;
            this.reportNull();
        }
        return 0;
    }

    @Override
    protected int readQuotedValue(char[] kw, int quoteChar) throws IOException, XMLStreamException {
        int i = 0;
        int len = kw.length;
        while (true) {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            if (c == quoteChar) {
                return i < len ? i : -1;
            }
            if (i >= len) continue;
            kw[i++] = c;
        }
    }

    @Override
    protected Location getLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._inputProcessed + this._inputPtr, this._inputRow, this._inputPtr - this._inputRowStart);
    }

    protected char nextChar() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLast) {
            this.loadMore();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected void skipCRLF(char lf) throws IOException, XMLStreamException {
        if (lf == '\r') {
            char c;
            char c2 = c = this._inputPtr < this._inputLast ? this._inputBuffer[this._inputPtr++] : this.nextChar();
            if (c != '\n') {
                --this._inputPtr;
            }
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }
}

