/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.fasterxml.aalto.dom;

import com.couchbase.client.deps.com.fasterxml.aalto.dom.BijectiveNsMap;
import com.couchbase.client.deps.com.fasterxml.aalto.dom.OutputElementBase;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMOutputElement
extends OutputElementBase {
    private DOMOutputElement _parent;
    private Element _element;
    private boolean _defaultNsSet;

    private DOMOutputElement() {
        this._parent = null;
        this._element = null;
        this._nsMapping = null;
        this._nsMapShared = false;
        this._defaultNsURI = "";
        this._rootNsContext = null;
        this._defaultNsSet = false;
    }

    private DOMOutputElement(DOMOutputElement parent, Element element, BijectiveNsMap ns) {
        super(parent, ns);
        this._parent = parent;
        this._element = element;
        this._nsMapping = ns;
        this._nsMapShared = ns != null;
        this._defaultNsURI = parent._defaultNsURI;
        this._rootNsContext = parent._rootNsContext;
        this._defaultNsSet = false;
    }

    private void relink(DOMOutputElement parent, Element element) {
        super.relink(parent);
        this._parent = parent;
        this._element = element;
        parent.appendNode(element);
        this._defaultNsSet = false;
    }

    public static DOMOutputElement createRoot() {
        return new DOMOutputElement();
    }

    protected DOMOutputElement createAndAttachChild(Element element) {
        if (this.isRoot()) {
            element.getOwnerDocument().appendChild(element);
        } else {
            this._element.appendChild(element);
        }
        return this.createChild(element);
    }

    protected DOMOutputElement createChild(Element element) {
        return new DOMOutputElement(this, element, this._nsMapping);
    }

    protected DOMOutputElement reuseAsChild(DOMOutputElement parent, Element element) {
        DOMOutputElement poolHead = this._parent;
        this.relink(parent, element);
        return poolHead;
    }

    protected void addToPool(DOMOutputElement poolHead) {
        this._parent = poolHead;
    }

    public DOMOutputElement getParent() {
        return this._parent;
    }

    @Override
    public boolean isRoot() {
        return this._parent == null;
    }

    @Override
    public String getNameDesc() {
        if (this._element != null) {
            return this._element.getLocalName();
        }
        return "#error";
    }

    @Override
    public void setDefaultNsUri(String uri) {
        this._defaultNsURI = uri;
        this._defaultNsSet = true;
    }

    @Override
    protected void setRootNsContext(NamespaceContext ctxt) {
        String defURI;
        this._rootNsContext = ctxt;
        if (!this._defaultNsSet && (defURI = ctxt.getNamespaceURI("")) != null && defURI.length() > 0) {
            this._defaultNsURI = defURI;
        }
    }

    protected void appendNode(Node n) {
        if (this.isRoot()) {
            this._element.getOwnerDocument().appendChild(n);
        } else {
            this._element.appendChild(n);
        }
    }

    protected void addAttribute(String pname, String value) {
        this._element.setAttribute(pname, value);
    }

    protected void addAttribute(String uri, String qname, String value) {
        this._element.setAttributeNS(uri, qname, value);
    }

    public void appendChild(Node n) {
        this._element.appendChild(n);
    }
}

