/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.query;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.query.parser.YasjlQueryResponseParser;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.KeepAlive;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.GenericQueryRequest;
import com.couchbase.client.core.message.query.PingRequest;
import com.couchbase.client.core.message.query.PingResponse;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.query.RawQueryRequest;
import com.couchbase.client.core.message.query.RawQueryResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import java.util.Queue;

public class QueryHandlerV2
extends AbstractGenericHandler<HttpObject, HttpRequest, QueryRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(QueryHandlerV2.class);
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private final YasjlQueryResponseParser parser;

    public QueryHandlerV2(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
        this.parser = new YasjlQueryResponseParser(this.env().scheduler(), this.env().autoreleaseAfter(), endpoint.environment());
    }

    QueryHandlerV2(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<QueryRequest> queue, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, queue, isTransient, pipeline);
        this.parser = new YasjlQueryResponseParser(this.env().scheduler(), this.env().autoreleaseAfter(), endpoint.environment());
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, QueryRequest msg) throws Exception {
        DefaultFullHttpRequest request;
        if (msg instanceof GenericQueryRequest) {
            GenericQueryRequest queryRequest = (GenericQueryRequest)msg;
            request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/query");
            request.headers().set("User-Agent", (Object)this.env().userAgent());
            if (queryRequest.isJsonFormat()) {
                request.headers().set("Content-Type", (Object)"application/json");
            }
        } else {
            if (msg instanceof KeepAliveRequest || msg instanceof PingRequest) {
                DefaultFullHttpRequest request2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/admin/ping");
                request2.headers().set("User-Agent", (Object)this.env().userAgent());
                request2.headers().set("Host", (Object)this.remoteHttpHost(ctx));
                return request2;
            }
            throw new IllegalArgumentException("Unknown incoming QueryRequest type " + msg.getClass());
        }
        ByteBuf query = ctx.alloc().buffer(((GenericQueryRequest)msg).query().length());
        query.writeBytes(((GenericQueryRequest)msg).query().getBytes(CHARSET));
        request.headers().add("Content-Length", (Object)query.readableBytes());
        request.headers().set("Host", (Object)this.remoteHttpHost(ctx));
        request.content().writeBytes(query);
        query.release();
        QueryHandlerV2.addHttpBasicAuth(ctx, request, msg.username(), msg.password());
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        AbstractCouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (this.currentRequest() instanceof KeepAliveRequest) {
            if (msg instanceof LastHttpContent) {
                response = new KeepAliveResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (this.currentRequest() instanceof PingRequest) {
            if (msg instanceof LastHttpContent) {
                response = new PingResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            boolean lastChunk = msg instanceof LastHttpContent;
            if (!this.parser.isInitialized()) {
                this.parser.initialize(this.responseContent, ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), (CouchbaseRequest)this.currentRequest());
            }
            if (this.currentRequest() instanceof RawQueryRequest) {
                response = this.handleRawQueryResponse(lastChunk, ctx);
            } else if (this.currentRequest() instanceof GenericQueryRequest) {
                response = this.parser.parse();
                if (lastChunk) {
                    this.parser.finishParsingAndReset();
                    this.finishedDecoding();
                }
            }
        }
        return response;
    }

    private RawQueryResponse handleRawQueryResponse(boolean lastChunk, ChannelHandlerContext ctx) {
        if (!lastChunk) {
            return null;
        }
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        ByteBuf responseCopy = ctx.alloc().buffer(this.responseContent.readableBytes(), this.responseContent.readableBytes());
        responseCopy.writeBytes(this.responseContent);
        return new RawQueryResponse(status, (CouchbaseRequest)this.currentRequest(), responseCopy, this.responseHeader.getStatus().code(), this.responseHeader.getStatus().reasonPhrase());
    }

    @Override
    protected void finishedDecoding() {
        this.releaseResponseContent();
        super.finishedDecoding();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseResponseContent();
        super.handlerRemoved(ctx);
    }

    private void releaseResponseContent() {
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
        }
        this.responseContent = null;
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.QUERY;
    }

    @InterfaceAudience.Private
    public ByteBuf getResponseContent() {
        return this.responseContent;
    }

    protected static class KeepAliveRequest
    extends AbstractCouchbaseRequest
    implements QueryRequest,
    KeepAlive {
        protected KeepAliveRequest() {
            super(null, null);
        }
    }

    protected static class KeepAliveResponse
    extends AbstractCouchbaseResponse {
        protected KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, request);
        }
    }
}

