/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.view;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.util.ClosingPositionBufProcessor;
import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.KeepAlive;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.view.GetDesignDocumentRequest;
import com.couchbase.client.core.message.view.GetDesignDocumentResponse;
import com.couchbase.client.core.message.view.PingRequest;
import com.couchbase.client.core.message.view.PingResponse;
import com.couchbase.client.core.message.view.RemoveDesignDocumentRequest;
import com.couchbase.client.core.message.view.RemoveDesignDocumentResponse;
import com.couchbase.client.core.message.view.UpsertDesignDocumentRequest;
import com.couchbase.client.core.message.view.UpsertDesignDocumentResponse;
import com.couchbase.client.core.message.view.ViewQueryRequest;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufProcessor;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.URLEncoder;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.AsyncSubject;

public class ViewHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, ViewRequest> {
    private static final int MAX_GET_LENGTH = 2048;
    private static final byte QUERY_STATE_INITIAL = 0;
    private static final byte QUERY_STATE_ROWS = 1;
    private static final byte QUERY_STATE_INFO = 2;
    private static final byte QUERY_STATE_ERROR = 3;
    private static final byte QUERY_STATE_DONE = 4;
    private HttpResponse responseHeader;
    private ByteBuf responseContent;
    private UnicastAutoReleaseSubject<ByteBuf> viewRowObservable;
    private UnicastAutoReleaseSubject<ByteBuf> viewInfoObservable;
    private AsyncSubject<String> viewErrorObservable;
    private byte viewParsingState = 0;

    public ViewHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
    }

    ViewHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<ViewRequest> queue, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, queue, isTransient, pipeline);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, ViewRequest msg) throws Exception {
        AbstractCouchbaseRequest queryMsg;
        if (msg instanceof KeepAliveRequest || msg instanceof PingRequest) {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/", Unpooled.EMPTY_BUFFER);
            request.headers().set("User-Agent", (Object)this.env().userAgent());
            request.headers().set("Content-Length", (Object)0);
            return request;
        }
        StringBuilder path = new StringBuilder();
        HttpMethod method = HttpMethod.GET;
        ByteBuf content = null;
        if (msg instanceof ViewQueryRequest) {
            boolean hasKeys;
            queryMsg = (ViewQueryRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((ViewQueryRequest)queryMsg).development() ? "dev_" + ((ViewQueryRequest)queryMsg).design() : ((ViewQueryRequest)queryMsg).design());
            if (((ViewQueryRequest)queryMsg).spatial()) {
                path.append("/_spatial/");
            } else {
                path.append("/_view/");
            }
            path.append(((ViewQueryRequest)queryMsg).view());
            int queryLength = ((ViewQueryRequest)queryMsg).query() == null ? 0 : ((ViewQueryRequest)queryMsg).query().length();
            int keysLength = ((ViewQueryRequest)queryMsg).keys() == null ? 0 : ((ViewQueryRequest)queryMsg).keys().length();
            boolean hasQuery = queryLength > 0;
            boolean bl = hasKeys = keysLength > 0;
            if (hasQuery || hasKeys) {
                if (queryLength + keysLength < 2048) {
                    if (hasQuery) {
                        path.append("?").append(((ViewQueryRequest)queryMsg).query());
                        if (hasKeys) {
                            path.append("&keys=").append(this.encodeKeysGet(((ViewQueryRequest)queryMsg).keys()));
                        }
                    } else {
                        path.append("?keys=").append(this.encodeKeysGet(((ViewQueryRequest)queryMsg).keys()));
                    }
                } else {
                    if (hasQuery) {
                        path.append("?").append(((ViewQueryRequest)queryMsg).query());
                    }
                    String keysContent = this.encodeKeysPost(((ViewQueryRequest)queryMsg).keys());
                    method = HttpMethod.POST;
                    content = ctx.alloc().buffer(keysContent.length());
                    content.writeBytes(keysContent.getBytes(CHARSET));
                }
            }
        } else if (msg instanceof GetDesignDocumentRequest) {
            queryMsg = (GetDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((GetDesignDocumentRequest)queryMsg).development() ? "dev_" + ((GetDesignDocumentRequest)queryMsg).name() : ((GetDesignDocumentRequest)queryMsg).name());
        } else if (msg instanceof UpsertDesignDocumentRequest) {
            method = HttpMethod.PUT;
            queryMsg = (UpsertDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((UpsertDesignDocumentRequest)queryMsg).development() ? "dev_" + ((UpsertDesignDocumentRequest)queryMsg).name() : ((UpsertDesignDocumentRequest)queryMsg).name());
            content = Unpooled.copiedBuffer(((UpsertDesignDocumentRequest)queryMsg).body(), CHARSET);
        } else if (msg instanceof RemoveDesignDocumentRequest) {
            method = HttpMethod.DELETE;
            queryMsg = (RemoveDesignDocumentRequest)msg;
            path.append("/").append(msg.bucket()).append("/_design/");
            path.append(((RemoveDesignDocumentRequest)queryMsg).development() ? "dev_" + ((RemoveDesignDocumentRequest)queryMsg).name() : ((RemoveDesignDocumentRequest)queryMsg).name());
        } else {
            throw new IllegalArgumentException("Unknown incoming ViewRequest type " + msg.getClass());
        }
        if (content == null) {
            content = Unpooled.buffer(0);
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path.toString(), content);
        request.headers().set("User-Agent", (Object)this.env().userAgent());
        request.headers().set("Content-Length", (Object)content.readableBytes());
        request.headers().set("Content-Type", (Object)"application/json");
        request.headers().set("Host", (Object)this.remoteHttpHost(ctx));
        ViewHandler.addHttpBasicAuth(ctx, request, msg.username(), msg.password());
        return request;
    }

    private String encodeKeysPost(String keys) {
        return "{\"keys\":" + keys + "}";
    }

    private String encodeKeysGet(String keys) {
        try {
            return URLEncoder.encode(keys, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not prepare view argument: " + ex);
        }
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        ViewRequest request = (ViewRequest)this.currentRequest();
        CouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (request instanceof KeepAliveRequest) {
            response = new KeepAliveResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), request);
            this.responseContent.clear();
            this.responseContent.discardReadBytes();
        } else if (request instanceof PingRequest) {
            if (msg instanceof LastHttpContent) {
                response = new PingResponse(ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code()), request);
                this.responseContent.clear();
                this.responseContent.discardReadBytes();
                this.finishedDecoding();
            }
        } else if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
            if (this.currentRequest() instanceof ViewQueryRequest) {
                if (this.viewRowObservable == null) {
                    response = this.handleViewQueryResponse();
                }
                this.parseQueryResponse(msg instanceof LastHttpContent);
            }
        }
        if (msg instanceof LastHttpContent) {
            if (request instanceof GetDesignDocumentRequest) {
                response = this.handleGetDesignDocumentResponse((GetDesignDocumentRequest)request);
                this.finishedDecoding();
            } else if (request instanceof UpsertDesignDocumentRequest) {
                response = this.handleUpsertDesignDocumentResponse((UpsertDesignDocumentRequest)request);
                this.finishedDecoding();
            } else if (request instanceof RemoveDesignDocumentRequest) {
                response = this.handleRemoveDesignDocumentResponse((RemoveDesignDocumentRequest)request);
                this.finishedDecoding();
            } else if (request instanceof KeepAliveRequest) {
                this.finishedDecoding();
            }
        }
        return response;
    }

    private CouchbaseResponse handleGetDesignDocumentResponse(GetDesignDocumentRequest request) {
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        return new GetDesignDocumentResponse(request.name(), request.development(), this.responseContent.copy(), status, request);
    }

    private CouchbaseResponse handleUpsertDesignDocumentResponse(UpsertDesignDocumentRequest request) {
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        return new UpsertDesignDocumentResponse(status, this.responseContent.copy(), request);
    }

    private CouchbaseResponse handleRemoveDesignDocumentResponse(RemoveDesignDocumentRequest request) {
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        return new RemoveDesignDocumentResponse(status, this.responseContent.copy(), request);
    }

    private CouchbaseResponse handleViewQueryResponse() {
        int code = this.responseHeader.getStatus().code();
        String phrase = this.responseHeader.getStatus().reasonPhrase();
        ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
        Scheduler scheduler = this.env().scheduler();
        long ttl = this.env().autoreleaseAfter();
        this.viewRowObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        this.viewInfoObservable = UnicastAutoReleaseSubject.create(ttl, TimeUnit.MILLISECONDS, scheduler);
        this.viewErrorObservable = AsyncSubject.create();
        this.viewRowObservable.withTraceIdentifier("viewRow");
        this.viewInfoObservable.withTraceIdentifier("viewInfo");
        return new ViewQueryResponse((Observable<ByteBuf>)this.viewRowObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<ByteBuf>)this.viewInfoObservable.onBackpressureBuffer().observeOn(scheduler), (Observable<String>)this.viewErrorObservable.observeOn(scheduler), code, phrase, status, (CouchbaseRequest)this.currentRequest());
    }

    private void parseQueryResponse(boolean last) {
        if (this.viewParsingState == 0) {
            this.parseViewInitial();
        }
        if (this.viewParsingState == 2) {
            this.parseViewInfo();
        }
        if (this.viewParsingState == 1) {
            this.parseViewRows(last);
        }
        if (this.viewParsingState == 3) {
            this.parseViewError(last);
        }
        if (this.viewParsingState == 4) {
            this.cleanupViewStates();
        }
    }

    private void cleanupViewStates() {
        this.completeRequestSpan((CouchbaseRequest)this.currentRequest());
        this.finishedDecoding();
        this.viewInfoObservable = null;
        this.viewRowObservable = null;
        this.viewErrorObservable = null;
        this.viewParsingState = 0;
    }

    private void parseViewInitial() {
        switch (this.responseHeader.getStatus().code()) {
            case 200: {
                this.viewParsingState = (byte)2;
                break;
            }
            default: {
                this.viewInfoObservable.onCompleted();
                this.viewRowObservable.onCompleted();
                this.viewParsingState = (byte)3;
            }
        }
    }

    private void parseViewError(boolean last) {
        if (!last) {
            return;
        }
        if (this.responseHeader.getStatus().code() == 200) {
            int openBracketPos = this.responseContent.bytesBefore((byte)91) + this.responseContent.readerIndex();
            int closeBracketLength = ViewHandler.findSectionClosingPosition(this.responseContent, '[', ']') - openBracketPos + 1;
            ByteBuf slice = this.responseContent.slice(openBracketPos, closeBracketLength);
            this.viewErrorObservable.onNext((Object)("{\"errors\":" + slice.toString(CharsetUtil.UTF_8) + "}"));
        } else {
            this.viewErrorObservable.onNext((Object)("{\"errors\":[" + this.responseContent.toString(CharsetUtil.UTF_8) + "]}"));
        }
        this.viewErrorObservable.onCompleted();
        this.viewParsingState = (byte)4;
        this.responseContent.discardReadBytes();
    }

    private void parseViewInfo() {
        int rowsStart = -1;
        for (int i = this.responseContent.readerIndex(); i < this.responseContent.writerIndex() - 2; ++i) {
            byte curr = this.responseContent.getByte(i);
            byte f1 = this.responseContent.getByte(i + 1);
            byte f2 = this.responseContent.getByte(i + 2);
            if (curr != 34 || f1 != 114 || f2 != 111) continue;
            rowsStart = i;
            break;
        }
        if (rowsStart == -1) {
            return;
        }
        ByteBuf info = this.responseContent.readBytes(rowsStart - this.responseContent.readerIndex());
        int closingPointer = info.forEachByteDesc(new ByteBufProcessor(){

            @Override
            public boolean process(byte value) throws Exception {
                return value != 44;
            }
        });
        if (closingPointer > 0) {
            info.setByte(closingPointer, 125);
            this.viewInfoObservable.onNext(info);
        } else {
            info.release();
            this.viewInfoObservable.onNext(Unpooled.EMPTY_BUFFER);
        }
        this.viewInfoObservable.onCompleted();
        this.viewParsingState = 1;
    }

    private void parseViewRows(boolean last) {
        while (true) {
            int openBracketPos;
            int errorBlockPosition;
            if ((errorBlockPosition = this.findErrorBlockPosition(openBracketPos = this.responseContent.bytesBefore((byte)123))) > 0 && errorBlockPosition < openBracketPos) {
                this.responseContent.readerIndex(errorBlockPosition + this.responseContent.readerIndex());
                this.viewRowObservable.onCompleted();
                this.viewParsingState = (byte)3;
                return;
            }
            int closeBracketPos = ViewHandler.findSectionClosingPosition(this.responseContent, '{', '}');
            if (closeBracketPos == -1) break;
            int from = this.responseContent.readerIndex() + openBracketPos;
            int to = closeBracketPos - openBracketPos - this.responseContent.readerIndex() + 1;
            this.viewRowObservable.onNext(this.responseContent.slice(from, to).copy());
            this.responseContent.readerIndex(closeBracketPos);
            this.responseContent.discardReadBytes();
        }
        if (last) {
            this.viewRowObservable.onCompleted();
            this.viewErrorObservable.onCompleted();
            this.viewParsingState = (byte)4;
        }
    }

    private int findErrorBlockPosition(int openBracketPos) {
        int readerIndex;
        int errorPosition = -1;
        for (int i = readerIndex = this.responseContent.readerIndex(); i < readerIndex + openBracketPos - 2; ++i) {
            byte curr = this.responseContent.getByte(i);
            byte f1 = this.responseContent.getByte(i + 1);
            byte f2 = this.responseContent.getByte(i + 2);
            if (curr != 34 || f1 != 101 || f2 != 114) continue;
            errorPosition = i;
            break;
        }
        return errorPosition > -1 ? errorPosition - this.responseContent.readerIndex() : errorPosition;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.viewRowObservable != null) {
            this.viewRowObservable.onCompleted();
            this.viewRowObservable = null;
        }
        if (this.viewInfoObservable != null) {
            this.viewInfoObservable.onCompleted();
            this.viewInfoObservable = null;
        }
        if (this.viewErrorObservable != null) {
            this.viewErrorObservable.onCompleted();
            this.viewErrorObservable = null;
        }
        this.cleanupViewStates();
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
        }
        super.handlerRemoved(ctx);
    }

    private static int findSectionClosingPosition(ByteBuf buf, char openingChar, char closingChar) {
        return buf.forEachByte(new ClosingPositionBufProcessor(openingChar, closingChar, true));
    }

    @Override
    protected CouchbaseRequest createKeepAliveRequest() {
        return new KeepAliveRequest();
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.VIEW;
    }

    protected static class KeepAliveRequest
    extends AbstractCouchbaseRequest
    implements ViewRequest,
    KeepAlive {
        protected KeepAliveRequest() {
            super(null, null);
        }
    }

    protected static class KeepAliveResponse
    extends AbstractCouchbaseResponse {
        protected KeepAliveResponse(ResponseStatus status, CouchbaseRequest request) {
            super(status, request);
        }
    }
}

