/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.observe;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.observe.ObserveViaCAS;
import com.couchbase.client.core.message.observe.ObserveViaMutationToken;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import java.util.concurrent.TimeUnit;
import rx.Observable;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class Observe {
    private static final Delay DEFAULT_DELAY = Delay.fixed(10L, TimeUnit.MILLISECONDS);

    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, long cas, boolean remove, PersistTo persistTo, ReplicateTo replicateTo, RetryStrategy retryStrategy) {
        return Observe.call(core, bucket, id, cas, remove, persistTo, replicateTo, DEFAULT_DELAY, retryStrategy);
    }

    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, long cas, boolean remove, PersistTo persistTo, ReplicateTo replicateTo, Delay delay, RetryStrategy retryStrategy) {
        return Observe.call(core, bucket, id, cas, remove, null, persistTo, replicateTo, delay, retryStrategy);
    }

    public static Observable<Boolean> call(ClusterFacade core, String bucket, String id, long cas, boolean remove, MutationToken token, PersistTo persistTo, ReplicateTo replicateTo, Delay delay, RetryStrategy retryStrategy) {
        if (token == null) {
            return ObserveViaCAS.call(core, bucket, id, cas, remove, persistTo, replicateTo, delay, retryStrategy);
        }
        return ObserveViaMutationToken.call(core, bucket, id, token, persistTo, replicateTo, delay, retryStrategy, cas);
    }

    public static enum ReplicateTo {
        NONE(0),
        ONE(1),
        TWO(2),
        THREE(3);

        private final short value;

        private ReplicateTo(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public boolean touchesReplica() {
            return this.value > 0;
        }
    }

    public static enum PersistTo {
        MASTER(-1),
        NONE(0),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4);

        private final short value;

        private PersistTo(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public boolean touchesReplica() {
            return this.value > 0;
        }
    }
}

