/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import java.util.HashMap;

public class ResponseStatusDetails {
    private static final ObjectMapper JACKSON = new ObjectMapper();
    private static final TypeReference<HashMap<String, HashMap<String, String>>> JACKSON_TYPEREF = new TypeReference<HashMap<String, HashMap<String, String>>>(){};
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ResponseStatusDetails.class);
    private final String reference;
    private final String context;

    public static ResponseStatusDetails convert(ByteBuf input) {
        if (input.readableBytes() <= 0) {
            return null;
        }
        try {
            byte[] inputBytes = new byte[input.readableBytes()];
            input.readBytes(inputBytes);
            HashMap result = (HashMap)JACKSON.readValue(inputBytes, JACKSON_TYPEREF);
            HashMap errorMap = (HashMap)result.get("error");
            if (errorMap == null) {
                LOGGER.warn("Exception while converting ResponseStatusDetails (no error json object), ignoring.");
                return null;
            }
            return new ResponseStatusDetails((String)errorMap.get("ref"), (String)errorMap.get("context"));
        }
        catch (Exception ex) {
            LOGGER.warn("Exception while converting ResponseStatusDetails, ignoring.", ex);
            return null;
        }
    }

    ResponseStatusDetails(String reference, String context) {
        this.reference = reference;
        this.context = context;
    }

    public String reference() {
        return this.reference;
    }

    public String context() {
        return this.context;
    }

    public String toString() {
        return "ResponseStatusDetails{reference='" + this.reference + '\'' + ", context='" + this.context + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseStatusDetails that = (ResponseStatusDetails)o;
        if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) {
            return false;
        }
        return this.context != null ? this.context.equals(that.context) : that.context == null;
    }

    public int hashCode() {
        int result = this.reference != null ? this.reference.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }

    public static String stringify(ResponseStatus status, ResponseStatusDetails details) {
        String result = status.toString();
        if (details != null) {
            result = result + " (Context: " + details.context() + ", Reference: " + details.reference() + ")";
        }
        return result;
    }
}

