/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.utils.monitor.mojo;

import com.btmatthews.utils.monitor.Logger;
import com.btmatthews.utils.monitor.Monitor;
import com.btmatthews.utils.monitor.MonitorObserver;
import com.btmatthews.utils.monitor.Server;
import com.btmatthews.utils.monitor.ServerFactory;
import com.btmatthews.utils.monitor.ServerFactoryLocator;
import com.btmatthews.utils.monitor.mojo.AbstractServerMojo;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunMojo
extends AbstractServerMojo
implements MonitorObserver {
    @Parameter(property="monitor.daemon", defaultValue="false")
    private boolean daemon;

    public abstract String getServerType();

    public abstract Map<String, Object> getServerConfig();

    @Override
    public void started(Server server, Logger logger) {
    }

    @Override
    public void stopped(Server server, Logger logger) {
    }

    public void execute() throws MojoFailureException {
        ServerFactoryLocator locator = ServerFactoryLocator.getInstance(this);
        ServerFactory factory = locator.getFactory(this.getServerType());
        Server server = factory.createServer();
        Map<String, Object> config = this.getServerConfig();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            server.configure(entry.getKey(), entry.getValue(), this);
        }
        Monitor monitor = this.createMonitor();
        if (this.daemon) {
            monitor.runMonitorDaemon(server, this, this);
        } else {
            monitor.runMonitor(server, this, this);
        }
    }
}

