/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.utils.monitor;

import com.btmatthews.utils.monitor.Logger;
import com.btmatthews.utils.monitor.MonitorObserver;
import com.btmatthews.utils.monitor.Server;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Monitor {
    private static final Pattern CONFIGURE_PATTERN = Pattern.compile("configure\\s+(\\w+)=(.*)");
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_RETRY_INTERVAL = 500;
    private static final String STOP = "stop";
    private final String monitorKey;
    private final int monitorPort;
    private int retryCount;
    private int retryInterval;

    public Monitor(String key, int port) {
        this(key, port, 3, 500);
    }

    public Monitor(String key, int port, int count, int interval) {
        this.monitorKey = key;
        this.monitorPort = port;
        this.retryCount = count;
        this.retryInterval = interval;
    }

    public static void sendCommand(String key, int port, String command, Logger logger) {
        new Monitor(key, port).sendCommand(command, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMonitor(Server server, Logger logger, MonitorObserver observer) {
        try {
            ServerSocket serverSocket = this.bindMonitor();
            try {
                server.start(logger);
                if (this.waitForStart(server, logger)) {
                    observer.started(server, logger);
                    this.runMonitorInternal(server, logger, serverSocket);
                    if (this.waitForStop(server, logger)) {
                        observer.stopped(server, logger);
                    }
                }
            }
            finally {
                serverSocket.close();
            }
        }
        catch (IOException exception) {
            logger.logError("Error starting or stopping the monitor", exception);
        }
    }

    public Thread runMonitorDaemon(final Server server, final Logger logger, final MonitorObserver observer) {
        Thread monitorThread = new Thread(new Runnable(){

            public void run() {
                Monitor.this.runMonitor(server, logger, observer);
            }
        });
        monitorThread.setDaemon(true);
        monitorThread.start();
        this.waitForStart(server, logger);
        return monitorThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMonitorInternal(Server server, Logger logger, ServerSocket serverSocket) {
        boolean running = true;
        while (running) {
            Socket clientSocket = null;
            try {
                try {
                    logger.logInfo("Waiting for command from client");
                    clientSocket = serverSocket.accept();
                    logger.logInfo("Receiving command from client");
                    clientSocket.setSoLinger(false, 0);
                    String command = this.getCommand(clientSocket, logger);
                    if (command == null) continue;
                    running = this.executeCommand(server, command, logger);
                }
                finally {
                    if (clientSocket == null) continue;
                    clientSocket.close();
                }
            }
            catch (IOException exception) {
                logger.logError("Error in the monitor", exception);
            }
        }
    }

    private String getCommand(Socket clientSocket, Logger logger) throws IOException {
        InputStream inputStream = clientSocket.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String key = lineReader.readLine();
        if (this.monitorKey.equals(key)) {
            return lineReader.readLine();
        }
        logger.logError("Invalid monitor key");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String command, Logger logger) {
        try {
            logger.logInfo("Sending command \"" + command + "\" to monitor");
            Socket socket = this.connectMonitor();
            try {
                socket.setSoLinger(false, 0);
                OutputStream outputStream = socket.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                PrintWriter printWriter = new PrintWriter(writer);
                printWriter.println(this.monitorKey);
                printWriter.println(command);
                printWriter.flush();
                socket.close();
            }
            finally {
                socket.close();
            }
        }
        catch (IOException exception) {
            logger.logError("Error sending command to monitor", exception);
        }
    }

    private boolean executeCommand(Server server, String command, Logger logger) {
        Matcher matcher = CONFIGURE_PATTERN.matcher(command);
        if (matcher.matches()) {
            server.configure(matcher.group(1), matcher.group(2), logger);
        } else if (STOP.equals(command)) {
            server.stop(logger);
            return false;
        }
        return true;
    }

    private boolean waitForStart(Server server, Logger logger) {
        if (server.isStarted(logger)) {
            return true;
        }
        try {
            Thread.sleep(this.retryInterval);
        }
        catch (InterruptedException e) {
            return false;
        }
        for (int i = 1; i < this.retryCount; ++i) {
            if (!server.isStarted(logger)) continue;
            return true;
        }
        return false;
    }

    private boolean waitForStop(Server server, Logger logger) {
        if (server.isStopped(logger)) {
            return true;
        }
        for (int i = 1; i < this.retryCount; ++i) {
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (!server.isStopped(logger)) continue;
            return true;
        }
        return false;
    }

    private ServerSocket bindMonitor() throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        try {
            serverSocket.bind(new InetSocketAddress(InetAddress.getLocalHost(), this.monitorPort), 1);
        }
        catch (BindException e) {
            serverSocket.bind(new InetSocketAddress("localhost", this.monitorPort), 1);
        }
        return serverSocket;
    }

    private Socket connectMonitor() throws IOException {
        try {
            return new Socket(InetAddress.getLocalHost(), this.monitorPort);
        }
        catch (ConnectException e) {
            return new Socket("localhost", this.monitorPort);
        }
    }
}

